//********************************************************************************
//								     Include
//********************************************************************************
#include  "MDRFxx_SFR.h"
#include  "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//The variables defined by data are placed in the first 128 bytes (0x00~0x7F) address space
//The variables defined by idata are placed in the (0x00~0xFF) address space
//The variable defined by xdata are placed in the external extended RAM  (generally refers to the external 0xF000~0xF1FF space, the specific space size varies with the MCU , and some MCU do not have external RAM)

//The variable defined by data is the fastest, followed by idata, and xdata is slower than the first two
//Variables that are often used are declared with data/idata; variables that are not commonly used are declared with xdata.
//No special declared variables, the default is data
idata unsigned char AdcCount;
unsigned short StartDelayCount = 0;

//********************************************************************************
//								Interrupt_Init
//********************************************************************************
void Interrupt_Init (void){
	EX0 = dIE0;								//External0_ISR interrupt 	0
	IT0 = dIT0;
	ET0 = dITR0;							//Timer0_ISR interrupt 		1
	EX1 = dIE1;								//External1_ISR interrupt 	2
	IT1 = dIT1;
	ET1 = dITR1;							//Timer1_ISR interrupt 		3
	ESP = dIUR;								//Uart_ISR interrupt 		4
	ET2 = dITR2;							//Timer2_ISR interrupt 		5
	OCPSIE = dIOCP;							//OCP_ISR interrupt 		8
	ADCIE = dIADC;							//ADC_ISR interrupt 		9
	MPWMMINIE = dIPWM_min;					//PmwMin_ISR interrupt 		10
	MPWMMAXIE = dIPWM_MAX;					//PmwMax_ISR interrupt 		11
	LVDIIE = dILVF;							//LowVoltage_ISR interrupt 	13
	WDTIE = dIWDF;							//WatchDoag_ISR interrupt 	14
	CAPIE = dICAP;							//Cap_ISR interrupt 		15
	
	IP0 = IP0_REGS;							//Interrupt Priority
	IP1 = IP1_REGS;							

	EA = 1;									//Allow interrupt
}
//********************************************************************************
//								     INT0
//********************************************************************************
/*void External0_ISR (void) interrupt 0{ // falling edge
	//zero_count = 0;
	trig_count = 0; // Clear zero-crossing timeout count
	zreo_cnt_f = 1;
	power_on = 1;
	vbus_zreo_f = 1; // Sampling V-BUS voltage at zero-crossing
	if(heat_lever > 1){
		if(Triac_cnt > trig_out_pwm) heat_en = 1;
		else                         heat_en = 0;
		Triac_cnt++;
		if(Triac_cnt > 25){
			Triac_cnt = 0;
			Triac_ctr_f = 1;// Temperature loop control enable
		}
	}else{
		heat_en = 1;
	}
}*/
//********************************************************************************
//								     Timer0
//********************************************************************************
void Timer0_ISR (void) interrupt 1{		//1mS
	TH0 = TIMER0_TH;
	TL0 = TIMER0_TL;
	
//	if(ZERO_Count < 1000) 	ZERO_Count++;
//	if(ZERO_Count > 100) 	ZERO_Check = 1;
	
	Motor_Control();
	#if 1
	if(StartDelayCount > 100){
		Start_Power_On = 1;
		#if (VSP_TRI == 0)
		//SystemState = 1;// Motor Start Flag 
		#endif
	}
	else{
		Start_Power_On = 0;
		SystemState = 0;
		StartDelayCount++;
	}
	#endif
	
	#if (PhaseLoss_Fun == 1)
		PhaseLoss();
	#endif
	
	#if (MotorLackPhase_Run == 1)
		MotorLackPhase_Run_Fun();	
	#endif
	
	//IPDCount += Timer1ms;
	//IPDCount &= 0xFFFF;
	
	TimerFlag = 1;
	TimerCount += Timer1ms;
	TimerCount &= 0xFF;
	
	#if (Uart_Debug == 1)
		UartCount += Timer1ms;
		if(UartCount >= PeriodTime10ms){
			UartCount = 0;
			UartFlag = 1;
			
			SFR_PAGE = 0; Debug_A = Heat_Enalbe_Cnt;//Temperture_avg;
			SFR_PAGE = 0; Debug_B = Heat_Temperture_avg;//Heat_Temperture_avg;
			SFR_PAGE = 2; Debug_C = Vbus_avg;//abs(FOC_D1);
			SFR_PAGE = 2; Debug_D = MotorErrorState;////abs(FOC_D2);
			SFR_PAGE = 6; Debug_E = SMO_D2;
			SFR_PAGE = 0; Debug_F = PI_CMD;
		}
		Uart_Read_Handle();
	#endif
	TF0 = 0;
}
//********************************************************************************
//								     INT1
//********************************************************************************
/*void External1_ISR (void) interrupt 2{ // high-end zero-crossing
	speed_high_offcnt = 0;
	speed_high_cnt++;
	if(speed_high_cnt >= 3){
		speed_high_cnt = 3;
		speed_lever = 2;
	}
}*/
//********************************************************************************
//								     Timer1
//********************************************************************************
void Timer1_ISR (void) interrupt 3{		//10mS
	TH1 = TIMER1_TH;
	TL1 = TIMER1_TL;

	#if (VSP_TRI == 1)
		Vsp_Fun();
	#endif
	
	#if (FaultLock_Protect == 1)
		FaultLock_Fun();
	#endif
	
	#if (Vbus_Protect == 1)
		Vbus_Protect_Fun(Vbus_avg);
	#endif
	
	#if (Temperture_Protect == 1)
		Temperture_Protect_Fun(Temperture_avg);
	#endif
	
	#if (POCP_Protect == 1)
		Phase_OCP_Protect_Fun();
	#endif
	
	#if (Heat_Temperture_Protect == 1)
		Heat_Temperture_Protect_Fun(Heat_Temperture_avg);
	#endif
	
	TF1 = 0;
}
//********************************************************************************
//								     UART
//********************************************************************************
#if (Uart_Debug == 1)
void Uart_ISR (void) interrupt 4{
	if(TI){
		Uart_Send_Buffer();
		TI = 0;
	}
	
	if(RI){
		Uart_Read_Buffer();
		RI = 0;
	}
}
#endif
//********************************************************************************
//								     Timer2
//********************************************************************************
/*void Timer2_ISR (void) interrupt 5{	//100uS
	TH2 = TIMER2_TH;//10mS @ 2MHz
	TL2 = TIMER2_TL;	
	
	TF2 = 0;
}*/
//********************************************************************************
//								  OCP interrupt
//********************************************************************************
void OCP_ISR (void) interrupt 8{
	AOCP_Protect_Fun();
}
//********************************************************************************
//								 ADC interrupt
//********************************************************************************
void ADC_ISR (void) interrupt 9{	//	1/PWM Frequency
	unsigned int Tmp;
	ZERO_Count++;
	if(ZERO_Count >= 2000) 	
	{
		ZERO_Count=2000;
		//ZERO_Check = 1;		
	}
	AdcCount++;
	AdcCount &= 0x07;
	#if (BEMF_TWO_TAILWIND_FUNCTION_RES == 1) || (BEMF_TWO_TAILWIND_FUNCTION_DIODE == 1) || (BEMF_ONE_TAILWIND_FUNCTION == 1)
		if((MotorState == M_TAILWIND) || (MotorState == M_IPD)){
			#if (BEMF_ONE_TAILWIND_FUNCTION == 1)
				BmfU = Adc_Cannel(BEMF_CH);
			#else
				BmfV = Adc_Cannel(BEMF_V_CH);
				BmfW = Adc_Cannel(BEMF_W_CH);
			#endif
		}
		else
	#endif
		{
		if(AdcCount == 0){
			#if (Vbus_Protect == 1)
				Vbus_avg = Adc_Cannel(V_BUS_CH);
			#endif
		}
		else if(AdcCount == 1){
			#if ((CONTROL_MODE == Power_Control) || (CONTROL_MODE == Power_Limit))
				//Ibus_avg = Adc_Cannel(I_BUS_CH);
			#endif
		}
		else if(AdcCount == 2){
			#if (VSP_TRI == 1)
				Vsp_avg = Adc_Cannel(VSP_CH);
				#if (Inver == 1)
					Vsp_avg = 1023 - Vsp_avg;
				#endif
			#endif
		}
		else if(AdcCount == 3){
			#if (Temperture_Protect == 1)
				if(i2c_Busy == 0){
					Tmp = Adc_Cannel(TEMPERTURE_CH); // Mos_Temperture 
					if(Temperture_avg < Tmp) Temperture_avg++; // To avoid ADC sampling surge, use this method
					else                     Temperture_avg--;
				}
			#endif
		}
		else if(AdcCount == 4){
			#if (Heat_Temperture_Protect == 1)
				//Heat_Temperture_avg = Adc_Cannel(HEAT_TEMPERTURE_CH); // Heat_Temperture
				Tmp = Adc_Cannel(HEAT_TEMPERTURE_CH);
				if(Heat_Temperture_avg < Tmp) Heat_Temperture_avg++;
				else                          Heat_Temperture_avg--;
			#endif
		}
		else if(AdcCount == 5){
			if(Speed < EstimatedSpeed) Speed++;
			else                       Speed--;
			#if ((MotorLackPhase == 1) || (MotorLackPhase_Run == 1))
				//Adc_AOCP = Adc_Cannel(2);
			#endif
		}
		else if(AdcCount == 6){
			#if (Uart_Debug == 1)
//			P2_4 = HEAT;
//			P0_6 = ZERO;
			#endif
			if(ZERO_OLD != ZERO){
				if(ZERO){
					Heat_Cnt++;
					ZeroFlag = 1;
				}
				else{
					ZERO_Count = 0;
					ZERO_Check = 0;
					HEAT = HEAT_OFF;
				}
			}
			ZERO_OLD = ZERO;
		}
	}
}
//********************************************************************************
//						    PWM_MIN_ISR interrupt
//********************************************************************************
/*void PmwMin_ISR (void) interrupt 10{
	//PwmFlag = 1;
}*/
//********************************************************************************
//						    PWM_MAX_ISR interrupt
//********************************************************************************
void PmwMax_ISR (void) interrupt 11{
	PwmFlag = 1;
}
//********************************************************************************
//						      LowVoltage interrupt
//********************************************************************************
//void LowVoltage_ISR (void) interrupt 13{
	
//}
//********************************************************************************
//						      WatchDoag interrupt
//********************************************************************************
//void WatchDoag_ISR (void) interrupt 14{

//}
//********************************************************************************
//						         CAP interrupt
//********************************************************************************
//void Cap_ISR (void) interrupt 15{

//}